/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.document.block;

import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.block.LytBlock;
import appeng.client.guidebook.document.interaction.GuideTooltip;
import appeng.client.guidebook.document.interaction.InteractiveElement;
import appeng.client.guidebook.document.interaction.ItemTooltip;
import appeng.client.guidebook.layout.LayoutContext;
import appeng.client.guidebook.render.RenderContext;
import appeng.core.AppEng;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_4597;

public class LytSlot
extends LytBlock
implements InteractiveElement {
    public static final class_2960 SLOT_LIGHT = AppEng.makeId("ae2guide/gui/slot_light.png");
    public static final class_2960 SLOT_DARK = AppEng.makeId("ae2guide/gui/slot_dark.png");
    public static final class_2960 LARGE_SLOT_LIGHT = AppEng.makeId("ae2guide/gui/large_slot_light.png");
    public static final class_2960 LARGE_SLOT_DARK = AppEng.makeId("ae2guide/gui/large_slot_dark.png");
    private static final int ITEM_SIZE = 16;
    private static final int PADDING = 1;
    private static final int LARGE_PADDING = 5;
    public static final int OUTER_SIZE = 18;
    public static final int OUTER_SIZE_LARGE = 26;
    private static final int CYCLE_TIME = 2000;
    private boolean largeSlot;
    private final class_1799[] stacks;

    public LytSlot(class_1856 ingredient) {
        this.stacks = ingredient.method_8105();
    }

    public LytSlot(class_1799 stack) {
        this.stacks = new class_1799[]{stack};
    }

    public boolean isLargeSlot() {
        return this.largeSlot;
    }

    public void setLargeSlot(boolean largeSlot) {
        this.largeSlot = largeSlot;
    }

    @Override
    protected LytRect computeLayout(LayoutContext context, int x, int y, int availableWidth) {
        if (this.largeSlot) {
            return new LytRect(x, y, 26, 26);
        }
        return new LytRect(x, y, 18, 18);
    }

    @Override
    protected void onLayoutMoved(int deltaX, int deltaY) {
    }

    @Override
    public void renderBatch(RenderContext context, class_4597 buffers) {
    }

    @Override
    public void render(RenderContext context) {
        int x = this.bounds.x();
        int y = this.bounds.y();
        class_2960 texture = this.largeSlot ? (context.isDarkMode() ? LARGE_SLOT_DARK : LARGE_SLOT_LIGHT) : (context.isDarkMode() ? SLOT_DARK : SLOT_LIGHT);
        context.fillTexturedRect(this.bounds, texture);
        int padding = this.largeSlot ? 5 : 1;
        class_1799 stack = this.getDisplayedStack();
        if (!stack.method_7960()) {
            context.renderItem(stack, x + padding, y + padding, 1, 16.0f, 16.0f);
        }
    }

    @Override
    public Optional<GuideTooltip> getTooltip(float x, float y) {
        class_1799 stack = this.getDisplayedStack();
        if (stack.method_7960()) {
            return Optional.empty();
        }
        return Optional.of(new ItemTooltip(stack));
    }

    private class_1799 getDisplayedStack() {
        if (this.stacks.length == 0) {
            return class_1799.field_8037;
        }
        long cycle = System.nanoTime() / TimeUnit.MILLISECONDS.toNanos(2000L);
        return this.stacks[(int)(cycle % (long)this.stacks.length)];
    }
}

